/********************************************************************
 * (C) Copyright 1998 by Hewlett-Packard GmbH. All rights reserved. *
 ********************************************************************/

/***********************************************************************
 * FILE  : b_streq.h
 * Include File 
 ***********************************************************************
 * Author: Henrik Liebau
 * Date  : 11 Mar 1998, 13:24:42
 ***********************************************************************/
 
#ifndef __b_streq_H__
#define __b_streq_H__

#include <string.h>


#ifndef UNIX
#  ifdef strncasecmp
#    undef strncasecmp
#  endif

#  ifdef __BORLANDC__
#    define strncasecmp strnicmp
#  else
#    define strncasecmp _strnicmp
#  endif
#endif

/***********************************************************************
 * This function compares two strings, based on the length of s2.
 * This means, if s1 contains s2 right at the beginning,
 * TRUE is returned.
 * also returns TRUE if both strings are empty or non-existent
 ***********************************************************************/
static int str_eq ( const char * s1, const char * s2 )
{
  int retval = 0;
   
  if (s2 && *s2)
  {
    retval = ( (s1 != 0) && ( strncasecmp(s1, s2, strlen(s2)) == 0 ) );
  }
  else
  {
    retval = ( s1 == 0 || s1[0] == 0 );
  }

  return retval;
}


#endif
